<?php
session_start();

const ADMIN_USER = 'admin';
const ADMIN_PASS = 'admin';

if (isset($_POST['login'])) {
    $u = trim($_POST['user'] ?? '');
    $p = trim($_POST['pass'] ?? '');
    if ($u === ADMIN_USER && $p === ADMIN_PASS) {
        $_SESSION['logged'] = true;
        header('Location: '.$_SERVER['PHP_SELF']);
        exit;
    }
    $error = 'بيانات الدخول غير صحيحة';
}
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: '.$_SERVER['PHP_SELF']);
    exit;
}
if (!($_SESSION['logged'] ?? false)) {
    echo '<!DOCTYPE html><html lang="ar" dir="rtl"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>تسجيل الدخول</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"></head><body class="bg-light d-flex justify-content-center align-items-center" style="height:100vh;">';
    echo '<div class="card p-4 shadow" style="min-width:340px;"><h4 class="text-center mb-3">تسجيل الدخول</h4>';
    if (!empty($error)) echo '<div class="alert alert-danger">'.$error.'</div>';
    echo '<form method="POST"><div class="mb-3"><label class="form-label">المستخدم</label><input type="text" name="user" class="form-control" required></div><div class="mb-3"><label class="form-label">كلمة المرور</label><input type="password" name="pass" class="form-control" required></div><button class="btn btn-primary w-100" name="login">دخول</button></form></div></body></html>';
    exit;
}

require_once __DIR__.'/indexing_common.php';
$FEED_FILE = __DIR__.'/feeds.txt';
$LOG_FILE  = __DIR__.'/cron.log';
$CRON_BIN  = '/usr/local/bin/php -q '.realpath(__DIR__.'/cron_feeds.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    header('Content-Type: application/json');
    $ajax = $_POST['ajax'];

    if ($ajax === 'submit_urls') {
        $reqType = $_POST['req_type'] ?? 'URL_UPDATED';
        $urls = [];
        $bulk = trim($_POST['urls_text'] ?? '');
        if ($bulk !== '') $urls = array_merge($urls, preg_split('/\R+/', $bulk));
        if (isset($_FILES['urls_file']['tmp_name']) && is_uploaded_file($_FILES['urls_file']['tmp_name'])) {
            $urls = array_merge($urls, file($_FILES['urls_file']['tmp_name'], FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES));
        }
        $urlsClean = array_unique(array_filter(array_map('trim', $urls)));
        $urlsReport = [];
        foreach ($urlsClean as $u) {
            if (!filter_var($u, FILTER_VALIDATE_URL)) {
                $urlsReport[] = ['url'=>$u,'status'=>'invalid','msg'=>'رابط غير صالح']; continue;
            }
            if (alreadySent($u,$reqType)) {
                $urlsReport[] = ['url'=>$u,'status'=>'skip','msg'=>'تم إرساله من قبل']; continue;
            }
            try {
                sendUrl($u,$reqType);
                $urlsReport[] = ['url'=>$u,'status'=>'ok','msg'=>'تم الإرسال'];
            } catch (Throwable $e) {
                $urlsReport[] = ['url'=>$u,'status'=>'fail','msg'=>$e->getMessage()];
            }
        }
        echo json_encode(['success'=>true, 'report'=>$urlsReport]); exit;
    }

    if ($ajax === 'add_single_feed') {
        $url = trim($_POST['new_feed'] ?? '');
        if (!filter_var($url, FILTER_VALIDATE_URL)) {
            echo json_encode(['success'=>false, 'msg'=>'رابط غير صالح']); exit;
        }
        $feeds = file_exists($FEED_FILE) ? file($FEED_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
        if (!in_array($url, $feeds)) file_put_contents($FEED_FILE, $url.PHP_EOL, FILE_APPEND | LOCK_EX);
        echo json_encode(['success'=>true]); exit;
    }

    if ($ajax === 'bulk_add_feed') {
        $added = 0;
        $lines = preg_split('/\R+/', trim($_POST['feeds_text'] ?? ''));
        foreach ($lines as $l) {
            if (filter_var($l, FILTER_VALIDATE_URL)) {
                file_put_contents($FEED_FILE, $l.PHP_EOL, FILE_APPEND | LOCK_EX);
                $added++;
            }
        }
        if (isset($_FILES['feeds_file']['tmp_name']) && is_uploaded_file($_FILES['feeds_file']['tmp_name'])) {
            $lines = file($_FILES['feeds_file']['tmp_name'], FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $l) {
                if (filter_var($l, FILTER_VALIDATE_URL)) {
                    file_put_contents($FEED_FILE, $l.PHP_EOL, FILE_APPEND | LOCK_EX);
                    $added++;
                }
            }
        }
        echo json_encode(['success'=>true, 'added'=>$added]); exit;
    }

    if ($ajax === 'delete_feed') {
        $del = trim($_POST['feed'] ?? '');
        if (!file_exists($FEED_FILE)) echo json_encode(['success'=>false]);
        else {
            $feeds = file($FEED_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            $filtered = array_filter($feeds, fn($f) => trim($f) !== $del);
            file_put_contents($FEED_FILE, implode(PHP_EOL, $filtered).PHP_EOL);
            echo json_encode(['success'=>true]);
        }
        exit;
    }

    if ($ajax === 'flush_db') {
        db()->exec('DELETE FROM sent');
        echo json_encode(['success'=>true]); exit;
    }

    if ($ajax === 'load_cron_log') {
        if (!file_exists($LOG_FILE)) {
            echo json_encode(['success'=>true, 'log'=>'']); exit;
        }
        $lines = array_slice(file($LOG_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES), -500);
        echo json_encode(['success'=>true, 'log'=>implode("\n", $lines)]); exit;
    }

    if ($ajax === 'clear_log') {
        if (file_exists($LOG_FILE)) file_put_contents($LOG_FILE, '');
        echo json_encode(['success'=>true]); exit;
    }

    echo json_encode(['success'=>false, 'msg'=>'طلب غير معروف']); exit;
}
?>
<!-- HTML و JavaScript الواجهة الأمامية يمكن إضافتها لاحقاً حسب الطلب -->


<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>لوحة إدارة الفهرسة</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.7.0.min.js" defer></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" defer></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js" defer></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js" defer></script>
<style>body{padding-top:3rem}table.dataTable tbody tr{font-size:.9rem}.cron-input{font-size:.75rem;direction:ltr}</style>
</head>
<body class="bg-light">
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="mb-0">لوحة Google Indexing API</h3>
        <a href="?logout" class="btn btn-outline-secondary btn-sm">تسجيل الخروج</a>
    </div>

    <ul class="nav nav-tabs" role="tablist">
        <li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#feeds" type="button">الخلاصات</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#urls"  type="button">إرسال روابط</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#sent"  type="button">المُرسَلة</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#logs"  type="button">سجل الكرون</button></li>
    </ul>

    <div class="tab-content bg-white p-4 border border-top-0 rounded-bottom">
        <div class="tab-pane fade show active" id="feeds" role="tabpanel">
            <form class="row g-3" id="singleFeedForm">
                <input type="hidden" name="new_feed">
                <div class="col-md-9"><input type="url" name="new_feed" class="form-control" placeholder="https://example.com/feed.xml" required></div>
                <div class="col-md-3"><button class="btn btn-primary w-100">إضافة خلاصة</button></div>
            </form><hr>
            <form id="bulkFeedForm" enctype="multipart/form-data" class="mb-3">
                <label class="form-label fw-bold">إضافة جماعية لخلاصات RSS:</label>
                <textarea name="feeds_text" class="form-control mb-2" rows="3"></textarea>
                <div class="d-flex align-items-center flex-wrap gap-2">
                    <input type="file" name="feeds_file" accept=".txt" class="form-control-file">
                    <button class="btn btn-success">إضافة</button>
                </div>
            </form><hr>
            <table class="table table-striped"><thead><tr><th>#</th><th>الخلاصة</th><th>Cron</th><th>حذف</th></tr></thead><tbody>
            <?php foreach (file_exists($FEED_FILE) ? file($FEED_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [] as $i=>$f): $fTrim=trim($f); $cron="$CRON_BIN \"$fTrim\""; ?>
                <tr>
                    <td><?= $i+1 ?></td>
                    <td dir="ltr"><a href="<?= htmlspecialchars($fTrim) ?>" target="_blank"><?= htmlspecialchars($fTrim) ?></a></td>
                    <td><input type="text" readonly class="form-control cron-input" value="<?= htmlspecialchars($cron) ?>"></td>
                    <td>
                        <form class="deleteFeedForm" data-url="<?= htmlspecialchars($fTrim) ?>">
                            <button type="submit" class="btn btn-sm btn-danger">✖</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody></table>
        </div>

        <div class="tab-pane fade" id="urls" role="tabpanel">
            <form id="submitUrlsForm" enctype="multipart/form-data">
                <input type="hidden" name="action" value="submit_urls">
                <div class="mb-3">
                    <label class="form-label">نوع الطلب:</label>
                    <select name="req_type" class="form-select">
                        <option value="URL_UPDATED">إضافة / تحديث</option>
                        <option value="URL_DELETED">حذف</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">الروابط (سطر لكل رابط):</label>
                    <textarea name="urls_text" class="form-control" rows="5"></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">أو رفع ملف TXT:</label>
                    <input type="file" name="urls_file" accept=".txt" class="form-control">
                </div>
                <button class="btn btn-primary">إرسال</button>
            </form>
            <div id="ajaxResult" class="mt-3"></div>
        </div>

        <div class="tab-pane fade" id="sent" role="tabpanel">
            <form id="flushDBForm" class="mb-2">
                <button class="btn btn-outline-danger btn-sm">مسح السجل</button>
            </form>
            <table id="sentTable" class="table table-sm table-bordered">
                <thead><tr><th>#</th><th>الرابط</th><th>النوع</th><th>الوقت</th></tr></thead>
                <tbody>
                    <?php foreach (db()->query("SELECT url,last_type,datetime(sent_at,'unixepoch','localtime') AS ts FROM sent ORDER BY sent_at DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC) as $i => $s): ?>
                    <tr>
                        <td><?= $i+1 ?></td>
                        <td dir="ltr"><?= htmlspecialchars($s['url']) ?></td>
                        <td><?= htmlspecialchars($s['last_type']) ?></td>
                        <td><?= htmlspecialchars($s['ts']) ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="tab-pane fade" id="logs" role="tabpanel">
            <form id="clearLogForm" class="mb-2">
                <button class="btn btn-outline-warning btn-sm">تفريغ السجل</button>
            </form>
            <pre id="cronLogArea" style="max-height:400px; overflow-y:scroll; background:#f9f9f9; padding:10px; font-size:0.85rem;">تحميل السجل...</pre>
        </div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function(){
    $('#sentTable').DataTable({responsive:true, pageLength: 25, language: {search: "بحث:", lengthMenu: "إظهار _MENU_ صف", info: "عرض _START_ إلى _END_ من _TOTAL_"}});

    $('#submitUrlsForm').on('submit', function(e){
        e.preventDefault();
        let formData = new FormData(this);
        formData.append('ajax', 'submit_urls');
        fetch(location.href, { method: 'POST', body: formData })
        .then(r => r.json())
        .then(data => {
            if (data.success) {
                let result = '';
                for (let row of data.report) {
                    result += `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>${row.url}</span>
                            <span class="badge bg-${row.status === 'ok' ? 'success' : (row.status === 'skip' ? 'secondary' : 'danger')}">${row.msg}</span>
                        </li>
                    `;
                }
                document.querySelector('#ajaxResult').innerHTML = `
                    <hr>
                    <h6 class="mt-4">نتائج الإرسال:</h6>
                    <ul class="list-group">${result}</ul>
                `;
            } else {
                alert('فشل في الإرسال');
            }
        });
    });

    $('#singleFeedForm').on('submit', function(e){
        e.preventDefault();
        const data = new FormData(this);
        data.append('ajax', 'add_single_feed');
        fetch(location.href, { method: 'POST', body: data })
        .then(r => r.json()).then(resp => { if (resp.success) location.reload(); });
    });

    $('#bulkFeedForm').on('submit', function(e){
        e.preventDefault();
        const data = new FormData(this);
        data.append('ajax', 'bulk_add_feed');
        fetch(location.href, { method: 'POST', body: data })
        .then(r => r.json()).then(resp => { if (resp.success) location.reload(); });
    });

    $(document).on('submit', '.deleteFeedForm', function(e){
        e.preventDefault();
        if (!confirm('حذف هذه الخلاصة؟')) return;
        const feed = this.dataset.url;
        const data = new FormData();
        data.append('ajax', 'delete_feed');
        data.append('feed', feed);
        fetch(location.href, { method: 'POST', body: data })
        .then(r => r.json()).then(resp => { if (resp.success) location.reload(); });
    });

    $('#flushDBForm').on('submit', function(e){
        e.preventDefault();
        if (!confirm('مسح السجل؟')) return;
        const data = new FormData();
        data.append('ajax', 'flush_db');
        fetch(location.href, { method: 'POST', body: data })
        .then(r => r.json()).then(resp => { if (resp.success) location.reload(); });
    });

    $('button[data-bs-target="#logs"]').on('shown.bs.tab', function () {
        fetch(location.href, {
            method: 'POST',
            body: new URLSearchParams({ ajax: 'load_cron_log' })
        })
        .then(r => r.json())
        .then(data => {
            document.getElementById('cronLogArea').textContent = data.success ? data.log : 'فشل في تحميل السجل';
        });
    });

    $('#clearLogForm').on('submit', function(e){
        e.preventDefault();
        if (!confirm('تفريغ السجل؟')) return;
        const form = new FormData();
        form.append('ajax', 'clear_log');
        fetch(location.href, { method: 'POST', body: form })
        .then(r => r.json()).then(data => {
            if (data.success) document.getElementById('cronLogArea').textContent = '';
        });
    });
});
</script>
</body>
</html>