#!/usr/bin/php -q
<?php
/* يشغَّل من سطر الأوامر فقط */
define('BASE', __DIR__);
require BASE.'/indexing_common.php';

$TYPE      = 'URL_UPDATED';          // نوع الطلب (تحديث)
$FEED_FILE = BASE.'/feeds.txt';      // ملف الخلاصات
$LOG       = BASE.'/cron.log';       // ملف الأخطاء

$DAILY_LIMIT = 100000; // الحد الأقصى اليومي حسب حصتك

if (!file_exists($FEED_FILE)) {
    die("feeds.txt غير موجود\n");
}

$feeds = file($FEED_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$feeds = array_unique(array_filter(array_map('trim', $feeds)));

$sent = 0;
$skipped = 0;
$invalid = 0;
$currentToday = dailySentCount();

foreach ($feeds as $feedUrl) {

    if (!isValidUrl($feedUrl)) {
        $invalid++;
        continue;
    }

    foreach (extractFeedLinks($feedUrl) as $url) {

        if (!isValidUrl($url)) {
            $invalid++;
            continue;
        }

        if (alreadySent($url, $TYPE)) {
            $skipped++;
            continue;
        }

        if (($sent + $currentToday) >= $DAILY_LIMIT) {
            echo "تم الوصول للحد اليومي المسموح به ($DAILY_LIMIT)\n";
            break 2;
        }

        try {
            sendUrl($url, $TYPE);
            $sent++;
            usleep(200000); // ← إرسال 5 روابط في الثانية (200ms تأخير)
        } catch (Throwable $e) {
            file_put_contents($LOG,
                date('c') . " خطأ في $url: " . $e->getMessage() . PHP_EOL,
                FILE_APPEND);
        }
    }
}

echo "تم الإرسال: $sent | مُتخطّى: $skipped | غير صالح: $invalid\n";
